﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI.HtmlControls;

using VIRP.EFR.BLL;
using VIRP.EFR.BO;

namespace VIRP_WEB.Custom.EFR
{
    public partial class PatientImageDetails : ImagingBasePage
    {
        private readonly PatientImageDetailManager patientImageDetailManager;

        private Dictionary<int, HtmlInputCheckBox> imageReasons;
        private Dictionary<int, HtmlInputCheckBox> bodyPartsImaged;

        public PatientImageDetails()
        {
            patientImageDetailManager = new PatientImageDetailManager();
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            ReplacePageTitle();

            if (ViewState[OriginallyNavigatedFrom] == null)
                ViewState[OriginallyNavigatedFrom] = Request.UrlReferrer;

            LoadControlCollections();

            if (!IsPostBack)
            {
                var patientSummary = GetOrStorePatientSummary();
                if (patientSummary != null)
                {
                    LabelPatientName.Text = "Patient Name: " + patientSummary.FullName;
                    LabelPatientSsn.Text = "Patient SSN: " + patientSummary.Snum;
                }

                int patientImageId;
                var patientImageIdPresent = int.TryParse(Request.QueryString["patientImageId"], out patientImageId);

                if (patientImageIdPresent)
                {
                    LoadData(patientSummary.Id, patientImageId);
                }
            }

            AddFormApplicationRole();
        }

        private void LoadControlCollections()
        {
            imageReasons = new Dictionary<int, HtmlInputCheckBox>
            {
                { 1, CheckBox_STD_IMAGE_REASON_C },
                { 2, CheckBox_STD_IMAGE_REASON_R },
                { 3, CheckBox_STD_IMAGE_REASON_P },
                { 4, CheckBox_STD_IMAGE_REASON_I },
                { 5, CheckBox_STD_IMAGE_REASON_N },
                { 6, CheckBox_STD_IMAGE_REASON_O }
            };

            bodyPartsImaged = new Dictionary<int, HtmlInputCheckBox>
            {
                { 1, CheckBox_STD_IMAGE_BODY_PART_H },
                { 2, CheckBox_STD_IMAGE_BODY_PART_C },
                { 3, CheckBox_STD_IMAGE_BODY_PART_UB },
                { 4, CheckBox_STD_IMAGE_BODY_PART_GR },
                { 5, CheckBox_STD_IMAGE_BODY_PART_LS },
                { 6, CheckBox_STD_IMAGE_BODY_PART_RS },
                { 7, CheckBox_STD_IMAGE_BODY_PART_LUA },
                { 8, CheckBox_STD_IMAGE_BODY_PART_RUA },
                { 9, CheckBox_STD_IMAGE_BODY_PART_LUT },
                { 10, CheckBox_STD_IMAGE_BODY_PART_RUT },
                { 11, CheckBox_STD_IMAGE_BODY_PART_LA },
                { 12, CheckBox_STD_IMAGE_BODY_PART_RA },
                { 13, CheckBox_STD_IMAGE_BODY_PART_N },
                { 14, CheckBox_STD_IMAGE_BODY_PART_AB },
                { 15, CheckBox_STD_IMAGE_BODY_PART_LB },
                { 16, CheckBox_STD_IMAGE_BODY_PART_BUT },
                { 17, CheckBox_STD_IMAGE_BODY_PART_LH },
                { 18, CheckBox_STD_IMAGE_BODY_PART_RH },
                { 19, CheckBox_STD_IMAGE_BODY_PART_LLA },
                { 20, CheckBox_STD_IMAGE_BODY_PART_RLA },
                { 21, CheckBox_STD_IMAGE_BODY_PART_LK },
                { 22, CheckBox_STD_IMAGE_BODY_PART_RK },
                { 23, CheckBox_STD_IMAGE_BODY_PART_LF },
                { 24, CheckBox_STD_IMAGE_BODY_PART_RF }
            };
        }

        private void LoadData(int patientId, int patientImageId)
        {
            var detail = patientImageDetailManager.GetPatientImageDetails(CurrentUser, CurrentRegistryId, patientImageId);
            if (detail != null)
                LoadControls(patientImageId, detail);

            // We do this so that saved changes are visible when we go "back"
            ButtonBack.PostBackUrl = string.Format("PatientImaging.aspx?patientId={0}", patientId);
        }

        private void LoadControls(int patientImageId, PatientImageDetail detail)
        {
            // Fragment Verified
            if (detail.FragmentVerified.HasValue)
                DropDownListFragmentDocumented.SelectedIndex = detail.FragmentVerified.Value ? 1 : 2;
            else
                DropDownListFragmentDocumented.SelectedIndex = 0;

            // Include in Report
            if (detail.IncludeInReport.HasValue)
                DropDownListIncludeInReport.SelectedIndex = detail.IncludeInReport.Value ? 1 : 2;
            else
                DropDownListIncludeInReport.SelectedIndex = 0;

            // Largest Fragment Length
            if (detail.LargestFragmentLength != null)
                TextBoxLargestFragmentLength.Value = detail.LargestFragmentLength.ToString();
            else
                TextBoxLargestFragmentLength.Value = string.Empty;

            // Largest Fragment Width
            if (detail.LargestFragmentWidth != null)
                TextBoxLargestFragmentWidth.Value = detail.LargestFragmentWidth.ToString();
            else
                TextBoxLargestFragmentWidth.Value = string.Empty;

            // Smallest Fragment Length
            if (detail.SmallestFragmentLength != null)
                TextBoxSmallestFragmentLength.Value = detail.SmallestFragmentLength.ToString();
            else
                TextBoxSmallestFragmentLength.Value = string.Empty;

            // Smallest Fragment Width
            if (detail.SmallestFragmentWidth != null)
                TextBoxSmallestFragmentWidth.Value = detail.SmallestFragmentWidth.ToString();
            else
                TextBoxSmallestFragmentWidth.Value = string.Empty;

            // Reviewed
            if (detail.Reviewed.HasValue)
                DropDownListReviewed.SelectedIndex = detail.Reviewed.Value ? 1 : 2;
            else
                DropDownListReviewed.SelectedIndex = 0;

            // Comments
            if (detail.Comments != null)
                TextBoxComments.Text = detail.Comments;
            else
                TextBoxComments.Text = string.Empty;

            // Image Reason Other Text
            if (detail.ImageReasonOtherText != null)
                TextBoxOtherImageReason.Text = detail.ImageReasonOtherText;
            else
                TextBoxOtherImageReason.Text = string.Empty;

            // Image Type  Other Text
            if (detail.ImageTypeOtherText != null)
                TextBoxOtherImageType.Text = detail.ImageTypeOtherText;
            else
                TextBoxOtherImageType.Text = string.Empty;

            // Load other controls
            LoadSelectedFragmentCountId(detail);
            LoadSelectedImageTypeId(detail);
            LoadReasonsForImaging(patientImageId);
            LoadBodyPartsImaged(patientImageId);

            // Other labels
            LabelSystemIDFragment.Text += detail.SystemIdentified.HasValue ? detail.SystemIdentified.Value ? "Yes" : "No" : "TBD";
            LabelStudyDescription.Text += detail.StudyDescription;
        }

        private void LoadSelectedFragmentCountId(PatientImageDetail detail)
        {
            var type = detail.ImageFragmentCountId;
            if (type.HasValue)
            {
                if (type == 1)
                    Radio_STD_IMAGE_FRAGMENT_COUNT_1.Checked = true;
                if (type == 2)
                    Radio_STD_IMAGE_FRAGMENT_COUNT_2_5.Checked = true;
                if (type == 3)
                    Radio_STD_IMAGE_FRAGMENT_COUNT_6_10.Checked = true;
                if (type == 4)
                    Radio_STD_IMAGE_FRAGMENT_COUNT_11_19.Checked = true;
                if (type == 5)
                    Radio_STD_IMAGE_FRAGMENT_COUNT_20.Checked = true;
            }
        }

        private void LoadSelectedImageTypeId(PatientImageDetail detail)
        {
            var type = detail.ImageTypeId;
            if (type.HasValue)
            {
                if (type == 1)
                    Radio_STD_IMAGE_TYPE_XR.Checked = true;
                if (type == 2)
                    Radio_STD_IMAGE_TYPE_CT.Checked = true;
                if (type == 3)
                    Radio_STD_IMAGE_TYPE_O.Checked = true;
            }
        }

        private void LoadReasonsForImaging(int patientImageId)
        {
            var reasons = PATIENT_IMAGE_REASONManager.GetItemsByPatientImageId(CurrentUser, CurrentRegistryId, patientImageId);
            if (reasons != null && reasons.Any())
            {
                var ids = reasons.Select(r => r.STD_IMAGE_REASON_ID);
                foreach (var id in ids)
                    imageReasons[id].Checked = true;
            }
        }

        private void LoadBodyPartsImaged(int patientImageId)
        {
            var parts = PATIENT_IMAGE_BODY_PARTManager.GetItemsByPatientImageId(CurrentUser, CurrentRegistryId, patientImageId);
            if (parts != null && parts.Any())
            {
                var ids = parts.Select(r => r.STD_IMAGE_BODY_PART_ID);
                foreach (var id in ids)
                    bodyPartsImaged[id].Checked = true;
            }
        }

        protected void ButtonSave_Click(object sender, EventArgs e)
        {
            var patientSummary = GetOrStorePatientSummary();

            int patientImageId;
            var patientImageIdPresent = int.TryParse(Request.QueryString["patientImageId"], out patientImageId);

            if (patientImageIdPresent)
            {
                PATIENT_IMAGE_REVIEW objSave = GetPatientImageReviewFromFields(patientSummary.Id, patientImageId);

                patientImageDetailManager.InsertUpdatePatientImageReview(
                    CurrentUser, CurrentRegistryId, objSave, GetBodyPartsImaged(), GetReasonsForImaging());

                SetSaveSuccessMessage();
            }
            else
                SetSaveMessage("Invalid Patient Image Id");
        }

        private PATIENT_IMAGE_REVIEW GetPatientImageReviewFromFields(int patientId, int patientImageId)
        {
            return new PATIENT_IMAGE_REVIEW
            {
                PATIENT_ID = patientId,
                PATIENT_IMAGE_ID = patientImageId,
                STD_IMAGE_FRAGMENT_COUNT_ID = GetSelectedFragmentCountId(),
                STD_IMAGE_TYPE_ID = GetSelectedImageTypeId(),
                FRAGMENT_VERIFIED_FLAG = GetDropDownListBooleanValue(DropDownListFragmentDocumented),
                REVIEWED_FLAG = GetDropDownListBooleanValue(DropDownListReviewed),
                INCLUDE_IN_REPORT_FLAG = GetDropDownListBooleanValue(DropDownListIncludeInReport),
                LARGEST_FRAGMENT_LENGTH = GetDecimalValueFromTextBox(TextBoxLargestFragmentLength),
                LARGEST_FRAGMENT_WIDTH = GetDecimalValueFromTextBox(TextBoxLargestFragmentWidth),
                SMALLEST_FRAGMENT_LENGTH = GetDecimalValueFromTextBox(TextBoxSmallestFragmentLength),
                SMALLEST_FRAGMENT_WIDTH = GetDecimalValueFromTextBox(TextBoxSmallestFragmentWidth),
                IMAGE_REASON_OTHER_TEXT = TextBoxOtherImageReason.Text,
                IMAGE_TYPE_OTHER_TEXT = TextBoxOtherImageType.Text,
                COMMENTS = TextBoxComments.Text
            };
        }

        private int? GetSelectedFragmentCountId()
        {
            if (Radio_STD_IMAGE_FRAGMENT_COUNT_1.Checked)
                return 1;
            if (Radio_STD_IMAGE_FRAGMENT_COUNT_2_5.Checked)
                return 2;
            if (Radio_STD_IMAGE_FRAGMENT_COUNT_6_10.Checked)
                return 3;
            if (Radio_STD_IMAGE_FRAGMENT_COUNT_11_19.Checked)
                return 4;
            if (Radio_STD_IMAGE_FRAGMENT_COUNT_20.Checked)
                return 5;
            return null;
        }

        private int? GetSelectedImageTypeId()
        {
            if (Radio_STD_IMAGE_TYPE_XR.Checked)
                return 1;
            if (Radio_STD_IMAGE_TYPE_CT.Checked)
                return 2;
            if (Radio_STD_IMAGE_TYPE_O.Checked)
                return 3;
            return null;
        }

        private int[] GetReasonsForImaging()
        {
            var reasons = new List<int>();

            foreach (var kv in imageReasons)
                if (kv.Value.Checked)
                    reasons.Add(kv.Key);

            return reasons.ToArray();
        }

        private int[] GetBodyPartsImaged()
        {
            List<int> parts = new List<int>();

            foreach (var kv in bodyPartsImaged)
                if (kv.Value.Checked)
                    parts.Add(kv.Key);

            return parts.ToArray();
        }
    }
}